#!/bin/bash

# Copyright (c) 2023-2024 Uvarov Andrey
# Interface LLC
# https://interface31.ru
# https://t.me/interface31
# v270724

# The MIT License
#Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
#The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
#THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

#Данная лицензия разрешает лицам, получившим копию данного программного обеспечения и сопутствующей документации (в дальнейшем именуемыми «Программное обеспечение»), безвозмездно использовать Программное обеспечение без ограничений, включая неограниченное право на использование, копирование, изменение, слияние, публикацию, распространение, сублицензирование и/или продажу копий Программного обеспечения, а также лицам, которым предоставляется данное Программное обеспечение, при соблюдении следующих условий:
#Указанное выше уведомление об авторском праве и данные условия должны быть включены во все копии или значимые части данного Программного обеспечения.
#ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ ПРЕДОСТАВЛЯЕТСЯ «КАК ЕСТЬ», БЕЗ КАКИХ-ЛИБО ГАРАНТИЙ, ЯВНО ВЫРАЖЕННЫХ ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ ГАРАНТИИ ТОВАРНОЙ ПРИГОДНОСТИ, СООТВЕТСТВИЯ ПО ЕГО КОНКРЕТНОМУ НАЗНАЧЕНИЮ И ОТСУТСТВИЯ НАРУШЕНИЙ, НО НЕ ОГРАНИЧИВАЯСЬ ИМИ. НИ В КАКОМ СЛУЧАЕ АВТОРЫ ИЛИ ПРАВООБЛАДАТЕЛИ НЕ НЕСУТ ОТВЕТСТВЕННОСТИ ПО КАКИМ-ЛИБО ИСКАМ, ЗА УЩЕРБ ИЛИ ПО ИНЫМ ТРЕБОВАНИЯМ, В ТОМ ЧИСЛЕ, ПРИ ДЕЙСТВИИ КОНТРАКТА, ДЕЛИКТЕ ИЛИ ИНОЙ СИТУАЦИИ, ВОЗНИКШИМ ИЗ-ЗА ИСПОЛЬЗОВАНИЯ ПРОГРАММНОГО ОБЕСПЕЧЕНИЯ ИЛИ ИНЫХ ДЕЙСТВИЙ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ.

echo ""
echo "#################### НАЧАЛО РАБОТЫ #####################"
echo ""
echo "Этот скрипт поможет вам обновить или установить сервер 1С"
echo "Для правильной работы разместите единый дистрибутив в одной директории со скриптом"
echo "(c) Уваров А.С. 2023-2024 interface31.ru"
echo ""
#Определяем и устанавливаем рабочую директорию скрипта
path=`dirname $0`
cd $path
echo "Чтобы начать установку введите setup."
echo "Для управления отладкой введите debug."
read -p "Чтобы начать обновление введите номер старой платформы: " oldver
if [[ $oldver = "debug" ]]; then
    read -p "Введите номер установленной платформы: " curver 
    if [[ $curver < '8.3.21' ]]; then
        echo "Управление отладкой поддерживается для платформы 8.3.21 и выше"
        exit 0
    fi
    if [[ ! -f /opt/1cv8/x86_64/$curver/uninstaller-full ]]; then
        echo "Не обнаружена установленная версия платформы $curver"
        exit 0
    fi
    if [[ ! -f /etc/systemd/system/srv1cv8-$curver@default.service.d/override.conf ]]; then
        echo "Теукущий статус: отладка выключена" 
    else
        echo "Теукущий статус: отладка включена"
        if [[ -z "`cat /etc/systemd/system/srv1cv8-$curver@default.service.d/override.conf | grep http`" ]]; then
            echo "Теукущий режим: TCP"
        else   
            echo "Теукущий режим: HTTP"     
        fi
    fi
    read -p "Для включения отладки введите протокол (tcp или http), для отключения введите off: " debug
    if [[ ! -d /etc/systemd/system/srv1cv8-$curver@default.service.d ]]; then
        mkdir /etc/systemd/system/srv1cv8-$curver@default.service.d
    fi
    if [[ $debug = "tcp" ]]; then
        echo "[Service]" > /etc/systemd/system/srv1cv8-$curver@default.service.d/override.conf
        echo "Environment=SRV1CV8_DEBUG=\"-debug -tcp\"" >> /etc/systemd/system/srv1cv8-$curver@default.service.d/override.conf
        echo "Включена отладка по TCP"
    fi
    if [[ $debug = "http" ]]; then
        echo "[Service]" > /etc/systemd/system/srv1cv8-$curver@default.service.d/override.conf
        echo "Environment=SRV1CV8_DEBUG=\"-debug -http\"" >> /etc/systemd/system/srv1cv8-$curver@default.service.d/override.conf
        echo "Включена отладка по HTTP"
    fi
    if [[ $debug = "off" ]]; then
        rm -f /etc/systemd/system/srv1cv8-$curver@default.service.d/override.conf
        echo "Отладка выключена"
    fi
    systemctl daemon-reload
    systemctl restart srv1cv8-$curver@default
    echo "############## ЗАВЕРШЕНИЕ РАБОТЫ ################"
    exit 0
fi
if [[ $oldver != "setup" ]]; then
    if [[ $oldver =~ ^8\.3\.[0-9]{2}\.[0-9]{4}$ ]]; then
        if [[ $oldver < '8.3.20' ]]; then
            if [ -n "`dpkg -l | grep $oldver`" ]; then
                echo "Обнаружена установленная версия платформы $oldver"
            else 
                echo "Не обнаружена установленная версия платформы $oldver"
                exit 0
            fi
        else
            if [ -f /opt/1cv8/x86_64/$oldver/uninstaller-full ]; then
                    echo "Обнаружена установленная версия платформы $oldver"
            else 
                echo "Не обнаружена установленная версия платформы $oldver"
                exit 0
            fi    
        fi
    else
        echo "Неверно указан номер платформы"
        exit 0
    fi
    echo ""
    echo "Платформа $oldver будет удалена"
    read -p "Для продолжения введите yes: " confirm
    if [[ $confirm != "yes" ]]; then
        echo "Отменено пользователем"
        echo "############## ЗАВЕРШЕНИЕ РАБОТЫ ################"
        exit 0
    fi
    # Удаляем платформу
    echo "Удаляем старую платформу"
    if [[ $oldver < '8.3.20' ]]; then
        systemctl stop srv1cv83
        update-rc.d -f srv1cv83 remove
        apt remove `dpkg -l | grep 1c-enterprise | grep ^ii | awk '{print $2}'` -y
        if [ -f /etc/init.d/srv1cv83 ]; then
            rm -f /etc/init.d/srv1cv83
        fi
        if [ -f /etc/default/srv1cv83 ]; then
            rm -f /etc/default/srv1cv83
        fi 
    elif [[ $oldver < '8.3.21' ]]; then   
        systemctl stop srv1cv83
        update-rc.d -f srv1cv83 remove
        /opt/1cv8/x86_64/$oldver/uninstaller-full --mode unattended
        if [ -f /etc/init.d/srv1cv83 ]; then
            rm -f /etc/init.d/srv1cv83
        fi
        if [ -f /etc/default/srv1cv83 ]; then
            rm -f /etc/default/srv1cv83
        fi 
    else
        systemctl stop srv1cv8-$oldver@default
        systemctl disable srv1cv8-$oldver@
        /opt/1cv8/x86_64/$oldver/uninstaller-full --mode unattended
    fi
    echo "Платформа $oldver удалена"
fi
echo ""
read -p "Введите номер новой платформы: " newver
if [[ $newver =~ ^8\.3\.[0-9]{2}\.[0-9]{4}$ ]]; then
    arcname=`echo $newver | sed 's/\./_/g'` 
   if [[ $newver < '8.3.20' ]]; then
        echo "Платформа версии ниже 8.3.20 не поддерживается"
	exit 0
    else
        if [ -f setup-full-$newver-x86_64.run ]; then
            echo "Найден дистрибутив платформы $newver"
        elif [ -f server64_$arcname.tar.gz ]; then
            echo "Найден архив дистрибутива платформы $newver" 
            echo "Распаковывваем, подождите..."
            tar -xzf server64_$arcname.tar.gz
            if [ -f setup-full-$newver-x86_64.zip ]; then
                echo "Найден промежуточный архив дистрибутива платформы $newver" 
                echo "Распаковывваем, подождите..."
                unzip -u setup-full-$newver-x86_64.zip
            fi
        elif [ -f server64_$arcname.zip ]; then
            echo "Найден архив дистрибутива платформы $newver" 
            echo "Распаковывваем, подождите..."
            unzip -u server64_$arcname.zip    
        else
            echo "Не обнаружен дистрибутив платформы $newver"
            exit 0
        fi
    fi
else
    echo "Неверно указан номер платформы"
    exit 0
fi
echo ""
echo "Платформа $newver будет установлена"
read -p "Для продолжения введите yes: " confirm
if [[ $confirm != "yes" ]]; then
    echo "Отменено пользователем"
    echo "############## ЗАВЕРШЕНИЕ РАБОТЫ ################"
    exit 0
fi
#Устанавливаем платформу
read -p "Требуется установка модуля расширения веб-сервера? Введите yes или no: " web
if [[ $web = "yes" ]]; then
    components=" --mode unattended --enable-components server,ws"
else
    components=" --mode unattended --enable-components server"
fi
if [ -z "`dpkg -l | grep lsb-release`" ]; then
    echo "Устанавливаем необходимые зависимости"
    apt update -y > /dev/null
    apt install lsb-release -y 
fi
echo ""
echo "Проверяем библиотеку libenchant1c2a"
if [[ "`lsb_release -si`" =~ ^AstraLinux ]]; then
    echo "Astra Linux. Проверка пропущена"
else
    codename=`lsb_release -sc`
    case $codename in
        stretch | buster)
            echo "Debian. Проверка пройдена"
            ;;
        bionic | focal)
            echo "Ubuntu. Проверка пройдена"
            ;; 
        tara | tessa | tina | tricia | ulyana | ulyssa | uma | una)
            echo "Mint. Проверка пройдена"
            ;;  
        *)
            if [ -z "`dpkg -l | grep libenchant1c2a`" ]; then
                echo "Пакет недоступен в репозиториях сисетемы!"
                read -p "Для подключения дополнительного репозитория (от Debian 10) введите yes: " libenchant
                 if [[ $libenchant = "yes" ]]; then
                    if [ -z "`dpkg -l | grep -w gnupg2`" ]; then
                        apt update -y > /dev/null
                        apt install gnupg2 -y 
                        gpg -k
                    fi
                    gpg --no-default-keyring --keyring /usr/share/keyrings/debian-archive-keyring.gpg --keyserver keyserver.ubuntu.com --recv "648ACFD622F3D138"                 
                    echo "deb [signed-by=/usr/share/keyrings/debian-archive-keyring.gpg] http://ftp.ru.debian.org/debian buster main" > /etc/apt/sources.list.d/buster.list
                    apt update -y > /dev/null  
                fi
            else
                echo "Пакет установлен в системе. Проверка пройдена" 
            fi 
            ;;
    esac
fi
echo "Устанавливаем новую платформу"
./setup-full-$newver-x86_64.run $components

if [[ $newver < '8.3.21' ]]; then
    ln -fs /opt/1cv8/x86_64/$newver/srv1cv83 /etc/init.d/srv1cv83
    ln -fs /opt/1cv8/x86_64/$newver/srv1cv83.conf /etc/default/srv1cv83
    update-rc.d srv1cv83 defaults
    systemctl start srv1cv83
    echo "Платформа 8.3.20 устанавливает вместе с 1С"
    echo "минимальную конфигурацию оболочки Gnome"
    read -p "Удалить Gnome (рекомендуется)? Введите yes или no: " nognome
    if [[ $nognome = "yes" ]]; then
        apt purge gnome-shell gnome-control-center gnome-keyring -y
        apt autoremove -y
    fi
else
    systemctl link /opt/1cv8/x86_64/$newver/srv1cv8-$newver@.service
    systemctl enable srv1cv8-$newver@
    systemctl start srv1cv8-$newver@default
fi
if [[ $web = "yes" ]]; then
    if [ -f /etc/apache2/apache2.conf ]; then
     sed -i 's/$oldver/$newver/g' /etc/apache2/apache2.conf 
     systemctl restart apache2
    fi
fi
echo ""
echo "Платформа $newver установлена"
echo ""
echo "############## ЗАВЕРШЕНИЕ РАБОТЫ #############"
echo ""